<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReportsTable extends Migration
{
    public function up(): void
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            
            $table->string('name'); // Report title
            $table->enum('report_type', [
                'customer_summary', 
                'policy_status', 
                'claims_overview', 
                'lead_performance', 
                'agent_activity', 
                'custom'
            ])->default('custom');

            $table->json('filters')->nullable(); // Stored filters/conditions
            $table->enum('output_format', ['pdf', 'excel', 'web'])->default('web');
            $table->boolean('is_scheduled')->default(false);
            $table->string('schedule_frequency')->nullable(); // daily, weekly, monthly
            $table->timestamp('last_generated_at')->nullable();

            $table->boolean('is_shared')->default(false); // Visible to other users
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reports');
    }
}

